/* Panneau d'affichage de messages */
/* Status Message
 Written by Becky Stewart
 For Adventures in Arduino, Wiley (2015)

 Hardware:
 * 10kOhm potentiometer
 * 3 LEDs (green, yellow, red)
 * 3 220 Ohm resistors


Copyright 2015 Becky Stewart

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
 */

// Les broches
int brochePot = A0;
int LEDVerte = 5;
int LEDJaune = 6;
int LEDRouge = 7;
void setup() {
  // Définition du mode OUTPUT (sortie) pour chaque broche des
  // LED
  pinMode(LEDVerte, OUTPUT);
  pinMode(LEDJaune, OUTPUT);
  pinMode(LEDRouge, OUTPUT);
  // Démarrage de la transmission série
  Serial.begin(9600);
}

void loop() {
  int valeurPot = analogRead (brochePot);
  // Impression de la valeur du potentiomètre
  Serial.print ("Le potentiomètre vaut :");
  Serial.println(valeurPot);
  // Si la valeur valeurPot est plus petite que 341
  if (valeurPot < 341) {
    Serial.println ("Allumage de la LED verte et extinction des LED jaune et rouge");
    // Allumer la LED verte
    digitalWrite(LEDVerte, HIGH);
    // Éteindre les LED jaune et rouge
    digitalWrite(LEDJaune, LOW);
    digitalWrite(LEDRouge, LOW);
  }
  // Si la valeur valeurPot est plus grande ou égale à 341
  // et inférieure à 682
  if (valeurPot >= 341 && valeurPot <682) {
    Serial.println ("Allumage de la LED jaune et extinction des LED verte et rouge");
    // Allumer la LED jaune
    digitalWrite(LEDJaune, HIGH);
    // Éteindre les LED verte et rouge
    digitalWrite(LEDVerte, LOW);
    digitalWrite(LEDRouge, LOW);
  }
  // Si la valeur valeurPot est plus grande ou égale à 682
  if (valeurPot >= 682) {
    Serial.println ("Allumage de la LED rouge et extinction des LED verte et jaune");
    // Allumer la LED rouge
    digitalWrite(LEDRouge, HIGH);
    // Éteindre les LED verte et jaune
    digitalWrite(LEDVerte, LOW);
    digitalWrite(LEDJaune, LOW);
  }
}
